% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TauConcept.R
\name{tauValue}
\alias{tauValue}
\alias{tijsValue}
\title{Compute tau-value}
\usage{
tauValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
tau-value for a quasi-balanced TU game with n players
}
\description{
Calculates the tau-value for a quasi-balanced TU game with n players.
}
\examples{
library(CoopGame)
tauValue(v=c(0,0,0,0,1,0,1))

\donttest{
#Example from article by Stach (2011)
library(CoopGame)
v=c(0,0,0,1,2,1,3)
tauValue(v) 
#[1] 1.2 0.6 1.2
}

}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 32

Tijs S. (1981) "Bounds for the core of a game and the t-value", In: Moeschlin, O. and Pallaschke, D. (Eds.): Game Theory and Mathematical Economics, North-Holland, pp. 123--132

Stach I. (2011) "Tijs value", Encyclopedia of Power, SAGE Publications, pp. 667--670
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
