% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightedVotingGame.R
\name{weightedVotingGameVector}
\alias{weightedVotingGameVector}
\alias{quotaGameVector}
\title{Compute game vector for a weighted voting game (aka quota game)}
\usage{
weightedVotingGameVector(n, w, q)
}
\arguments{
\item{n}{represents the number of players}

\item{w}{numeric vector which contains the weight of each player}

\item{q}{is the quota}
}
\value{
Game Vector where each element contains \code{1} if the sum of 
the weights of coalition \code{S} is greater or equal than 
quota \code{q}, else \code{0}
}
\description{
\strong{Game vector for a specified weighted voting game:} \cr
For further information see \link{weightedVotingGame}
}
\examples{
library(CoopGame)
weightedVotingGameVector(n=3,w=c(1,2,3),q=4)

}
\references{
Peleg B. (2002) "Game-theoretic analysis of voting in committees". in: Handbook of Social Choice and Welfare 1, pp. 195--201

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 17

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 825--831
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}

Michael Maerz
}
