% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.spatialvalid.R
\name{plot.spatialvalid}
\alias{plot.spatialvalid}
\title{Plot Method for Class Spatialvalid}
\usage{
\method{plot}{spatialvalid}(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  bgmap = NULL,
  clean = TRUE,
  details = FALSE,
  pts_size = 1,
  font_size = 10,
  zoom_f = 0.1,
  ...
)
}
\arguments{
\item{x}{an object of the class \code{spatialvalid} as from
\code{\link{clean_coordinates}}.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimallongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimallatitude}.}

\item{bgmap}{an object of the class \code{SpatialPolygonsDataFrame} used as
background map. Default = ggplot::borders()}

\item{clean}{logical.  If TRUE, non-flagged coordinates are included in the
map.}

\item{details}{logical. If TRUE, occurrences are color-coded by the type of
flag.}

\item{pts_size}{numeric. The point size for the plot.}

\item{font_size}{numeric. The font size for the legend and axes}

\item{zoom_f}{numeric. the fraction by which to expand the plotting area 
from the occurrence records. Increase, if countries do not show 
up on the background map.}

\item{\dots}{arguments to be passed to methods.}
}
\value{
A plot of the records flagged as potentially erroneous by
\code{\link{clean_coordinates}}.
}
\description{
A set of plots to explore objects of the class \code{spatialvalid}. A plot
to visualize the flags from clean_coordinates
}
\examples{


exmpl <- data.frame(species = sample(letters, size = 250, replace = TRUE),
                    decimallongitude = runif(250, min = 42, max = 51),
                    decimallatitude = runif(250, min = -26, max = -11))

test <- clean_coordinates(exmpl, species = "species", 
                          tests = c("sea", "gbif", "zeros"),
                          verbose = FALSE)

summary(test)
plot(test)
}
\seealso{
\code{\link{clean_coordinates}}
}
\keyword{Visualisation}
