% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_login.r
\name{cms_login}
\alias{cms_login}
\title{Contact Copernicus Marine login page}
\usage{
cms_login(
  username = getOption("CopernicusMarine_uid", ""),
  password = getOption("CopernicusMarine_pwd", "")
)
}
\arguments{
\item{username}{Your Copernicus marine user name. Can be provided as
\code{options(CopernicusMarine_uid = "my_user_name")}, or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{options(CopernicusMarine_pwd = "my_password")}, or as argument here.}
}
\value{
Returns a \code{logical} value indicating if the login is successful.
The response from the login page is returned as an attribute named \code{response}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Contact Copernicus Marine login page
and check if login is successful.
}
\details{
This function will return a logical value indicating if the login is successful.
It can be used to test your account details.
}
\examples{
\dontrun{
## This will return FALSE if you have not set your account details with 'options'.
## If you have specified your account details and there are no other problems,
## it will return TRUE.
cms_login()
}
}
\author{
Pepijn de Vries
}
