% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recMID.R
\name{recMID}
\alias{recMID}
\alias{plot.recMID}
\title{recMID.}
\usage{
recMID(mid = NULL, r = list(`M+H` = 1), fml = NULL, cutoff = 0.001)

\method{plot}{recMID}(x, ...)
}
\arguments{
\item{mid}{A numeric vector with sum=1 and length of C atoms +1.}

\item{r}{Fragment ratios. A numeric vector with sum=1.}

\item{fml}{A compound formula.}

\item{cutoff}{Remove values below this threshold from output vector.}

\item{x}{Object of class recMID.}

\item{...}{Further plotting parameters.}
}
\value{
A reconstructed MID.
}
\description{
\code{recMID} will reconstruct a measured GC-APCI-MS spectrum
 of a compound given its true MID and the fragment ratio.
}
\details{
tbd
}
\examples{
fml <- "C9H20O3Si2"
mid <- c(0.9,0,0,0.1)
r <- list("M+H"=0.8, "M-H"=0.1, "M+H2O-CH4"=0.1)
(rMID <- CorMID::recMID(mid=mid, r=r, fml=fml))
plot(rMID)
plot(x = rMID, ylim=c(0,max(rMID)))
plot(x = rMID, xlim=c(-2,12), ylim=NULL, col=2, lwd=12, las=2, xlab="label")
\donttest{
CorMID::CorMID(int = rMID, fml=fml, prec=0.001, r=unlist(r), trace_steps = TRUE)
}
}
