% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readZ.R
\name{readZ}
\alias{readZ}
\title{read the structure and explain it}
\usage{
readZ(Z = Z, B = NULL, crit = c("none", "R2", "F", "sigmaX"),
  varnames = NULL, output = c("index", "names", "all"), X = NULL,
  order = 1)
}
\arguments{
\item{Z}{binary adjacency matrix of the structure (size p)}

\item{B}{is the complete structure (Z with sub-regression coefficients instead of 1 and an additional first line for the intercepts)}

\item{crit}{define the criterion to use: c("none","R2","F","sigmaX")}

\item{varnames}{the names of the variables (size p)}

\item{output}{indicates the content of the output: c("index","names","all")}

\item{X}{is a data frame or matrix containing the dataset}

\item{order}{define the order used (0: none, -1: decreasing, 1: growing) for printing}
}
\value{
a list containing the sub-regressions details
}
\description{
This function describes the structure of sub-regression given by an adjacency matrix. It computes the associated regression coefficients and R-squared for each sub-regression.
}
\examples{
\dontrun{

data<-mtcars
#we first search a sub-regression structure
res=structureFinder(X = data,nbini = 30,verbose=0)
#then we can try to interpret it
readZ(Z = res$Z_opt,crit = "R2",output = "all",X = data)
#each component is a sub-regression
#First line : The adjusted R-squared is given
#Second line : the name of the covariate that is regressed by others
#other lines : Coefficients of sub-regression and name of the associated covariate
}
}

