% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFunction.R
\name{fitFunction}
\alias{fitFunction}
\title{Fit Function to Data}
\usage{
fitFunction(dataset = cs.in.dataset(), preds = cs.in.predictors(),
  resps = cs.in.responses(), groups = cs.in.groupvars(),
  scriptvars = cs.in.scriptvars(), return.results = FALSE)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictors.}

\item{resps}{[\code{character}]\cr
Character vector of responses.}

\item{groups}{[\code{character}]\cr
Character vector of groups.}

\item{scriptvars}{[\code{list}]\cr
Named list of script variables set via the Cornerstone "Script Variables" menu.
\code{NULL} invokes the default values.
See below for details.}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}
}
\value{
Logical [\code{TRUE}] invisibly or, if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} objects:
  \item{coeff}{Estimated coefficients and standard errors for every variable.}
  \item{predictions}{
    Brushable dataset with predictions and residuals added to original values and groups,
    if available.
  }
}
\description{
Fit predefined functions to data via nonlinear least squares using \code{\link{nls}}.
}
\details{
One script variables is summarized in \code{scriptvars} list:\cr
  \describe{
    \item{math.fun}{[\code{character(1)}]\cr
      Function selection for fitting data.}
  }
}
\examples{
# Generate data from logistic function:
fun = function(x, a, b, c, d, sigma = 1) {
  a+(b-a) / (1+exp(-d*(x-c))) + rnorm(length(x), sd = sigma)
  }
library(data.table)
dt = data.table(  x1 = sample(seq(-10, 10, length.out = 100))
                  , group1 = sample(x = c("A", "B"), replace = TRUE, size = 100)
                  )
dt[group1 == "A", y1 := fun(x1, 1, 10, 1, 0.6, 0.1)]
dt[group1 == "B", y1 := fun(x1, 8, 2, -1, 0.3, 0.1)]
# Fit the logistic function:
res = fitFunction(dt, "x1", "y1", "group1", list(math.fun = "Logistic"), TRUE)
# Show estimated coefficients:
res$coeff
# Plot fitted vs. residuals:
plot(res$predictions$Fitted, res$predictions$Residuals)
}
