% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pdf}
\alias{betabin.pdf}
\alias{pdf}
\alias{qpower.pdf}
\title{Parametric distributions for correlated binary data}
\usage{
betabin.pdf(p, rho, n)

qpower.pdf(p, rho, n)
}
\arguments{
\item{p}{numeric, the probability of success.}

\item{rho}{numeric between 0 and 1 inclusive, the within-cluster correlation.}

\item{n}{integer, cluster size.}
}
\value{
a numeric vector of length \eqn{n+1} giving the value of \eqn{P(X=x)}
for \eqn{x=0,\ldots,n}.
}
\description{
\code{qpower.pdf} and \code{betabin.pdf} calculate the probability
distribution function for the number of responses in a cluster of the q-power
and beta-binomial distributions, respectively.
}
\details{
The pdf of the q-power distribution is \deqn{P(X=x) =
{{n}\choose{x}}\sum_{k=0}^x (-1)^k{{x}\choose{k}}q^{(n-x+k)^\gamma},}{P(X=x)
= C(n,x)\sum_{k=0}^x (-1)^kC(x,k)q^((n-x+k)^g),} \eqn{x=0,\ldots,n}, where
\eqn{q=1-p}, and the intra-cluster correlation \deqn{\rho =
\frac{q^{2^\gamma}-q^2}{q(1-q)}.}{rho = (q^(2^g)-q^2)/(q(1-q)).}

The pdf of the beta-binomial distribution is \deqn{P(X=x) = {{n}\choose{x}}
\frac{B(\alpha+x, n+\beta-x)}{B(\alpha,\beta)},}{P(X=x) = C(n,x)
B(a+x,n+b-x)/B(a,b),} \eqn{x=0,\ldots,n}, where \eqn{\alpha=
p\frac{1-\rho}{\rho}}{a=p(1-rho)/rho}, and \eqn{\alpha=
(1-p)\frac{1-\rho}{\rho}}{b=(1-p)(1-rho)/rho}.
}
\examples{
#the distributions have quite different shapes
#with q-power assigning more weight to the "all affected" event than other distributions
plot(0:10, betabin.pdf(0.3, 0.4, 10), type="o", ylim=c(0,0.34),
  ylab="Density", xlab="Number of responses out of 10")
lines(0:10, qpower.pdf(0.3, 0.4, 10), type="o", col="red")
}
\author{
Aniko Szabo, aszabo@mcw.edu
}
\references{
Kuk, A. A (2004) litter-based approach to risk assessement in
developmental toxicity studies via a power family of completely monotone
functions \emph{Applied Statistics}, 52, 51-61.

Williams, D. A. (1975) The Analysis of Binary Responses from Toxicological
Experiments Involving Reproduction and Teratogenicity \emph{Biometrics}, 31,
949-952.
}
\seealso{
\code{\link{ran.CBData}} for generating an entire dataset using
these functions
}
\keyword{distribution}

