% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_counternull_values.R
\name{find_counternull_values}
\alias{find_counternull_values}
\title{Find Counternull Values}
\usage{
find_counternull_values(null_r, counts = NULL, bw = NULL)
}
\arguments{
\item{null_r}{"null_rand" object corresponding to data}

\item{counts}{Vector containing lower and upper bounds for number of
test statistics more extreme than observed test statistic in
counternull randomization distribution (optional)}

\item{bw}{Histogram bin width (optional)}
}
\value{
Class "counternull" with 6 entries:
\describe{
\item{counternull_perm}{Counternull test statistics for first counternull set}
\item{low}{Counternull test statistics for second counternull set}
\item{high}{Lower bound of counternull set}
\item{counternull_perm_two}{Upper bound of counternull set}
\item{low_two}{Lower bound of second counternull set}
\item{high_two}{Upper bound of second counternull set}
\item{null_rand}{Specified "null_rand" object}
\item{bw}{Specified bin width}
}
}
\description{
Retrieves counternull value set and returns object of "counternull" class.
}
\details{
Call summary on "counternull" class to retrieve range of counternull values.
Call plot on "counternull" class for visualization
of counternull distribution.

Argument "counts" must contain whole numbers for bounds.Lower bound must be
smaller than upper bound. If argument is not specified, counternull values
will be obtained using the "counts" argument from the specified "null_rand"
argument.

If no counternull values are found, all entries in class are set to null.
If only one set of counternull values are found, "perm_two", low_two"
and "high_two" are set to null.
}
\examples{
\donttest{
n_r = create_null_rand(sample_data$turn_angle, sample_data$w,
sample_matrix, test_stat = c("diffmeans"))
c = find_counternull_values(n_r)
summary(c)
plot(c)
c = find_counternull_values(n_r, c(56,60))
summary(c)
}

}
\references{
\doi{10.1111/j.1467-9280.1994.tb00281.x}
}
