% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dWeibullgamma.R
\name{dWeibullgammaCount_acc}
\alias{dWeibullgammaCount_acc}
\alias{dWeibullgammaCount}
\alias{dWeibullgammaCount_loglik}
\alias{evWeibullgammaCount}
\title{Fast Univariate Weibull Count Probability with gamma heterogeneity}
\usage{
dWeibullgammaCount_acc(x, shape, r, alpha, time = 1, logFlag = FALSE,
  jmax = 100L, nmax = 300L, eps = 1e-10, printa = FALSE)

dWeibullgammaCount(x, shape, shapeGam, scaleGam, Xcovar = NULL,
  beta = NULL, method = c("series_acc", "series_mat"), time = 1,
  log = FALSE, series_terms = 50, series_acc_niter = 300,
  series_acc_eps = 1e-10)

dWeibullgammaCount_loglik(x, shape, shapeGam, scaleGam, Xcovar = NULL,
  beta = NULL, method = c("series_acc", "series_mat"), time = 1,
  na.rm = TRUE, series_terms = 50, series_acc_niter = 300,
  series_acc_eps = 1e-10, weights = NULL)

evWeibullgammaCount(xmax, shape, shapeGam, scaleGam, Xcovar = NULL,
  beta = NULL, method = c("series_acc", "series_mat"), time = 1,
  series_terms = 50, series_acc_niter = 300, series_acc_eps = 1e-10)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{shape}{numeric, shape parameter.}

\item{r}{numeric shape of the gamma distribution}

\item{alpha}{numeric rate of the gamma distribution}

\item{time}{double, length of the observation window (defaults to 1).}

\item{logFlag}{logical, if TRUE, the log of the probability will be returned.}

\item{jmax}{integer, number of terms used to approximate the (infinite)
series.}

\item{nmax}{integer, an upper bound on the number of terms to be summed in
the Euler-van Wijngaarden sum; default is 300 terms.}

\item{eps}{numeric, the desired accuracy to declare convergence.}

\item{printa}{logical, if \code{TRUE} print information about convergence.}

\item{shapeGam, scaleGam}{numeric shape and scale parameters of the gamma
heterogeity function.}

\item{Xcovar}{matrix the regressor values. Should have the same number of
rows as \code{length(x)}. If NULL, no regression will be considered.}

\item{beta}{numeric regression coefficients. If NULL, no regression will be
considered.}

\item{method}{character one of the available methods. See details.}

\item{log}{logical, if TRUE, the log of the probability will be returned.}

\item{series_terms}{numeric number of terms in the series expansion.}

\item{series_acc_niter}{numeric number of iteration in the Euler-van
Wijngaarden algorithm.}

\item{series_acc_eps}{numeric tolerance of convergence in the Euler-van
Wijngaarden algorithm.}

\item{na.rm}{logical, if TRUE, \code{NA}'s (produced by taking the log of
very small probabilities) will be replaced by the smallest allowed
probaility; default = \code{TRUE}.}

\item{weights}{numeric, vector of weights to apply. If \code{NULL}, one will
be applied.}

\item{xmax}{unsigned integer, maximum count to be used.}

\item{shape}{numeric (length 1), shape parameter of the Weibull count.}

\item{x}{integer (vector), the desired count values.}

\item{time}{double, length of the observation window (defaults to 1).}
}
\value{
for \code{dWeibullgammaCount}, a vector of probabilities
    \eqn{P(x(i)), i = 1, \dots n} where \code{n = length(x)}.

for \code{dWeibullgammaCount_loglik}, double,
    log-likelihood of the count process

for \code{evWeibullgammaCount}, a list with components
    \code{"ExpectedValue"} and \code{"Variance"}.
}
\description{
Probability computations for the univariate Weibull-gamma count processes. Several
methods are provided.
\code{dWeibullgammaCount} computes probabilities.

\code{dWeibullgammaCount_loglik} computes the log-likelihood.

\code{evWeibullgammaCount} computes the expected value and variance.
}
\details{
The desired method can be specified by argument \code{method}, as follows:
\describe{
\item{\code{"series_mat"}}{series expansion using matrix techniques.}
\item{\code{"series_acc"}}{Euler-van Wijngaarden accelerated series expansion.}
}
The arguments have sensible default values.
}
\keyword{internal}
