% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovDist.R
\name{CovDist}
\alias{CovDist}
\title{Compute Pairwise Distance for Symmetric Positive-Definite Matrices}
\usage{
CovDist(
  A,
  method = c("A", "B", "C", "E", "H", "J", "K", "L", "PS", "PF", "PE", "RE"),
  power = 1,
  as.dist = FALSE
)
}
\arguments{
\item{A}{a \eqn{(p\times p\times N)} 3d array of \eqn{N} SPD matrices.}

\item{method}{the type of distance measures to be used;
\describe{
\item{\code{"A"}}{(AIRM) Affine Invariant Riemannian Metric}
\item{\code{"B"}}{(Bhattacharyya) Bhattacharyya distance based on normal model}
\item{\code{"C"}}{(Cholesky) Cholesky difference in Frobenius norm}
\item{\code{"E"}}{(Euclidean) naive Frobenius norm as distance}
\item{\code{"H"}}{(Hellinger) Hellinger distance based on normal model}
\item{\code{"J"}}{(JBLD) Jensen-Bregman Log Determinant Distance}
\item{\code{"K"}}{(KLDM) symmetrized Kullback-Leibler Distance Measure}
\item{\code{"L"}}{(LERM) Log Euclidean Riemannian Metric}
\item{\code{"PS"}}{(Procrustes.SS) Procrustes Size and Shape measure}
\item{\code{"PF"}}{(Procrustes.Full) Procrustes analysis with scale}
\item{\code{"PE"}}{(PowerEuclidean) weighted eigenvalues by some exponent}
\item{\code{"RE"}}{(RootEuclidean) matrix square root}
}}

\item{power}{a non-zero number for PowerEuclidean distance.}

\item{as.dist}{a logical; \code{TRUE} to return a \code{dist} object, \code{FALSE} otherwise.}
}
\value{
an \eqn{(N\times N)} symmetric matrix of pairwise distances or a \code{dist} object via \code{as.dist} option.
}
\description{
For a given 3-dimensional array where symmetric positive definite (SPD) matrices are stacked slice
by slice, it computes pairwise distance using various popular measures. Some of measures
are \emph{metric} as they suffice 3 conditions in mathematical context; nonnegative definiteness,
symmetry, and triangle inequalities. Other non-metric measures represent \emph{dissimilarities} between
two SPD objects.
}
\examples{
## generate 50 SPD matrices of size (5-by-5)
samples = samplecovs(50,5)

## get pairwise distance for several methods
distA = CovDist(samples, method="A")
distB = CovDist(samples, method="B")
distC = CovDist(samples, method="C")

## dimension reduction using MDS
ssA = stats::cmdscale(distA, k=2)
ssB = stats::cmdscale(distB, k=2)
ssC = stats::cmdscale(distC, k=2)

## visualize
opar <- par(mfrow=c(1,3), pty="s")
plot(ssA ,main="project with AIRM", pch=19)
plot(ssB ,main="project with Bhattacharyya", pch=19)
plot(ssC ,main="project with Cholesky", pch=19)
par(opar)

}
\references{
\insertRef{arsigny_log-euclidean_2006}{CovTools}

\insertRef{dryden_non-euclidean_2009}{CovTools}
}
