% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--filter_tools--sd_trend_outlier.R
\name{Flag_From_Trend}
\alias{Flag_From_Trend}
\title{Flag values as outliers based on error from estimated trend
This function can be done within group if the data fed into it was grouped}
\usage{
Flag_From_Trend(DF, base_data, trend_data, sd_degree = 2.5)
}
\arguments{
\item{DF}{Dataframe containing selected columns}

\item{base_data}{Name of column containing Raw data}

\item{trend_data}{Name of generated trend data}

\item{sd_degree}{Threshold to flag deviant values as an outlier}
}
\value{
DF with a new column 'flagged_outlier' that contains if the column is an outlier
}
\description{
Flag values as outliers based on error from estimated trend
This function can be done within group if the data fed into it was grouped
}
\examples{
library(dplyr)
data("Example_data", package = "Covid19Wastewater")
smoothing_df <- Example_data\%>\%
    select(site, date, N1, N2)\%>\%
    filter(N1 != 0, N2 != 0)\%>\%
    mutate(N1 = log(N1), N2 = log(N2), N12_avg = (N1 + N2) / 2)
    df_data <- loessSmoothMod(smoothing_df, "N12_avg", "N12_avg_loess", Filter = NULL)
head(df_data\%>\%
   group_by(site)\%>\%
   Flag_From_Trend( N12_avg, N12_avg_loess)\%>\%
   select(site, date, N12_avg, flagged_outlier))
}
