% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_coxmos.R
\name{coxmos}
\alias{coxmos}
\title{Coxmos Modeling Function}
\usage{
coxmos(
  method = c("cox", "coxSW", "coxEN", "splsicox", "splsdrcox", "splsdrcox_penalty",
    "splsdacox"),
  X,
  Y,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = FALSE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE,
  max.variables = NULL,
  BACKWARDS = TRUE,
  alpha_ENT = 0.1,
  alpha_OUT = 0.15,
  toKeep.sw = NULL,
  initialModel = NULL,
  EN.alpha = 0.5,
  n.comp = 4,
  penalty = 0.5,
  vector = NULL,
  MIN_NVAR = 1,
  MAX_NVAR = NULL,
  n.cut_points = 5,
  MIN_AUC_INCREASE = 0.01,
  EVAL_METHOD = "AUC",
  pred.method = "cenROC",
  max.iter = 200,
  times = NULL,
  max_time_points = 15,
  FORCE = FALSE
)
}
\arguments{
\item{method}{Modeling method to use: "cox", "coxSW", "coxEN", "splsicox", "splsdrcox", "splsdrcox_penalty", or "splsdacox" (default: cox).}

\item{X}{Numeric matrix or data.frame. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the threshold
(default: 0.05).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}

\item{max.variables}{Numeric. Maximum number of variables you want to keep in the cox model. If
MIN_EPV is not meet, the value will be change automatically (default: 20) (coxSW, coxEN).}

\item{BACKWARDS}{Logical. If BACKWARDS = TRUE, backward strategy is performed (default: TRUE) (coxSW).}

\item{alpha_ENT}{Numeric. Maximum P-Value threshold for an ANOVA test when comparing a more complex
model to a simpler model that includes a new variable. If the p-value is less than or equal to this
threshold, the new variable is considered significantly important and will be added to the model
(default: 0.10) (coxSW).}

\item{alpha_OUT}{Numeric. Minimum P-Value threshold for an ANOVA test when comparing a simpler model
to a more complex model that excludes an existing variable. If the p-value is greater than or equal
to this threshold, the existing variable is considered not significantly important and will be removed
from the model (default: 0.15) (coxSW).}

\item{toKeep.sw}{Character vector. Name of variables in X to not be deleted by Step-wise
selection (default: NULL) (coxSW).}

\item{initialModel}{Character vector. Name of variables in X to include in the initial model
(default: NULL) (coxSW).}

\item{EN.alpha}{Numeric. Elastic net mixing parameter. If EN.alpha = 1 is the lasso penalty, and
EN.alpha = 0 the ridge penalty (default: 0.5). NOTE: When ridge penalty is used, EVP and
max.variables will not be used (coxEN).}

\item{n.comp}{Numeric. Number of latent components to compute for the (s)PLS model (default: 4) (splsicox, splsdrcox, splsdrcox_penalty, splsdacox).}

\item{penalty}{Numeric. Penalty for variable selection for the individual cox models. Variables
with a lower P-Value than 1 - "penalty" in the individual cox analysis will be keep for the approach
(default: 0.5) (splsicox, splsdrcox_penalty).}

\item{vector}{Numeric vector. Used for computing best number of variables. As many values as
components have to be provided. If vector = NULL, an automatic detection is perform (default: NULL) (splsdrcox, splsdacox).}

\item{MIN_NVAR}{Numeric. Minimum range size for computing cut points to select the best number of
variables to use (default: 1) (splsdrcox, splsdacox).}

\item{MAX_NVAR}{Numeric. Maximum range size for computing cut points to select the best number of
variables to use. If NULL, the number of variables is selected (default: NULL) (splsdrcox, splsdacox).}

\item{n.cut_points}{Numeric. Number of cut points for searching the optimal number of variables.
If only two cut points are selected, minimum and maximum size are used. For MB approaches as many
as n.cut_points^n.blocks models will be computed as minimum (default: 5) (splsdrcox, splsdacox).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values in the multiple tested parameters. If it is not reached for next
'MIN_COMP_TO_CHECK' models and the minimum 'MIN_AUC' value is reached, the evaluation stops
(default: 0.01) (splsdrcox, splsdacox).}

\item{EVAL_METHOD}{Character. The selected metric will be use to compute the best
number of variables. Must be one of the following: "AUC", "IBS" or "C.Index" (default: "AUC") (splsdrcox, splsdacox).}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC") (splsdrcox, splsdacox).}

\item{max.iter}{Numeric. Maximum number of iterations for PLS convergence (default: 200) (splsdrcox, splsdacox).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL) (splsdrcox, splsdacox).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15) (splsdrcox, splsdacox).}

\item{FORCE}{Logical. In case the MIN_EPV is not meet, it allows to compute the model (default: FALSE) (cox).}
}
\value{
A Coxmos model specified by the method argument.
}
\description{
This function provides a unified interface for all HD-COX modeling methods in the package.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]

# Elastic Net Cox
model_en <- coxmos(method = "coxEN", X = X_train, Y = Y_train, EN.alpha = 0.7)
}
\seealso{
\code{\link{cox}} for standard Cox model,
\code{\link{coxSW}} for stepwise selection,
\code{\link{coxEN}} for elastic net,
\code{\link{splsicox}} for SPLS-COX,
\code{\link{splsdrcox}} for SPLS-DRCOX,
\code{\link{splsdrcox_penalty}} for penalized SPLS-DRCOX,
\code{\link{splsdacox}} for SPLS-DACOX
}
