% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds2.R
\name{cds2}
\alias{cds2}
\title{Calculate Credit Default Swap rates}
\usage{
cds2(t, T, tr, r, tint, int, R = 0.005, ...)
}
\arguments{
\item{t}{premium timetable.}

\item{T}{CDS maturities.}

\item{tr}{interest rates timetable.}

\item{r}{spot interest rates.}

\item{tint}{intensity timetable.}

\item{int}{default intensities timetable.}

\item{R}{constant premium payment.}

\item{...}{further arguments on \code{cds}.}
}
\value{
An object of class \code{data.frame} that contains the quantities calculated by \code{cds}
on T timetable.
}
\description{
Calculate CDS rates starting from default intensities
}
\details{
The function \code{cds2} is based on \code{cds} but allows a more fine controll on maturities
and on discretization of \code{r} and \code{int}. In particular input \code{(t, tr, tint)}
can be of different length thanks to the function \link[stats]{approx}.
}
\examples{
cds2( t=seq(0.5, 30, by=0.5), T =c(5,10,30),
tr = c(0.5, 1, 2, 3, 4, 5, 7, 10, 20, 30),
       r=c(-0.275, -0.244, -0.169, -0.082,  0.020,
       0.135,  0.389,  0.765,  1.366,  1.455), tint=c(1,2,5),
       int=c(.01,.005,.003), R=0.005, simplified=TRUE )

}
\references{
David Lando (2004) Credit Risk Modeling.

Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes
}
