% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merton.sim.R
\name{Merton.sim}
\alias{Merton.sim}
\title{Firm value in Merton's model}
\usage{
Merton.sim(V0, r, sigma, t, n, seed = as.numeric(Sys.time()))
}
\arguments{
\item{V0}{firm value at time \code{t = 0}.}

\item{r}{risk-free interest rate (constant for all t).}

\item{sigma}{volatility (constant for all t).}

\item{t}{a vector of debt maturity structure.}

\item{n}{number of trajectories to be generated.}

\item{seed}{starting seed, default seed is setted randomly.}
}
\value{
This function returns a matrix containing the simulated firm values.
}
\description{
With this function we simulate \code{n} trajectories of firm value based on
Merton's model.
}
\details{
The trajectories are calculated according to the equation:
\deqn{V_T = V_0 \exp{\int_0^T dln V_t}}
Where we express \code{dln V_t} using Ito's lemma to derive the differential
of the logarithm of the firm value as:
\deqn{dln V_t =(\mu - \frac{\sigma^2}{2})dt + \sigma dW_t}
}
\examples{
V <- Merton.sim(V0 = 20, r = 0.05, sigma = 0.2, t = seq(0, 30, by = 0.5), n = 5)
matplot(x = seq(0, 30, by = 0.5), y = V, type = 's', lty = 1, xlab = 'Time',
ylab = 'Firm value trajectories', main = "Trajectories of the firm values in the Merton's model")

}
\references{
Gergely Daròczi, Michael Puhle, Edina Berlinger, Péter Csòka, Dàniel Havran
Màrton Michaletzky, Zsolt Tulasay, Kata Vàradi, Agnes Vidovics-Dancs (2013)
Introduction to R for Quantitative Finance.
}
