% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bw.R
\name{make_bw}
\alias{make_bw}
\title{Changes a grayscale image to black and white}
\usage{
make_bw(image)
}
\arguments{
\item{image}{The image generated after the ExG transformation in the EBImage format.}
}
\value{
A binary image
}
\description{
Takes in a grayscale image and finds the best threshold for binarization of the image.
}
\details{
This function uses the \url{https://github.com/aoles/EBImage/blob/master/R/otsu.R} otsu function from EBImage to make the grayscale image into a binary black and white image. How the otsu transformation works and chooses the threshold can be understood more clearly at \url{http://www.labbookpages.co.uk/software/imgProc/otsuThreshold.html}.
}
\examples{
\donttest{BW_Image <- make_bw(image)}

}
