/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;

public class Design {
    String title;
    String reference;
    String signature;
    public int t;
    public int s;
    public int p;
    String design;
    Double efficiencyAdj = null;
    Double efficiencyUnadj = null;
    String result = null;
    String rName = null;
    String uniqueName = null;

    public Design(String title, String rName) {
        this(title, rName, null);
    }

    public Design(String title, String rName, String reference) {
        this.title = title;
        this.rName = rName;
        this.reference = reference;
        this.saveDesign2R(true);
        this.t = RControl.getR().eval("length(levels(as.factor(" + this.uniqueName + ")))").asRInteger().getData()[0];
        int[] dim = RControl.getR().eval("dim(" + this.uniqueName + ")").asRInteger().getData();
        this.p = dim[0];
        this.s = dim[1];
        this.design = RControl.getR().eval("paste(capture.output(dput(" + this.uniqueName + ")), collapse=\"\")").asRChar().getData()[0];
        double[] eff = RControl.getR().eval("Crossover:::getEff(" + (rName == null ? this.design : rName) + ")").asRNumeric().getData();
        this.efficiencyUnadj = eff[0];
        this.efficiencyAdj = eff[1];
    }

    public Design(String title, String rName, String reference, String signature, int t, int s, int p, String design) {
        this.title = title;
        this.rName = rName;
        this.reference = reference;
        this.signature = signature;
        this.t = t;
        this.s = s;
        this.p = p;
        this.design = design;
        double[] eff = RControl.getR().eval("Crossover:::getEff(" + (rName == null ? design : rName) + ")").asRNumeric().getData();
        this.efficiencyUnadj = eff[0];
        this.efficiencyAdj = eff[1];
        this.saveDesign2R(true);
    }

    public String saveDesign2R(boolean useRName) {
        if (useRName) {
            this.uniqueName = "CODesign." + RControl.getR().eval("digest::digest(getDesign(" + this.rName + "))").asRChar().getData()[0];
            RControl.getR().eval(this.uniqueName + "<- getDesign(" + this.rName + ")");
        }
        RControl.getR().eval("attr(" + this.uniqueName + ",\"rName\") <- \"" + this.rName + "\"");
        if (this.reference != null) {
            RControl.getR().eval("attr(" + this.uniqueName + ",\"reference\") <- \"" + Design.escape(this.reference) + "\"");
        }
        RControl.getR().eval("attr(" + this.uniqueName + ",\"title\") <- \"" + Design.escape(this.title) + "\"");
        return this.uniqueName;
    }

    public static String escape(String s) {
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\"", "\\\\\"");
        return s;
    }

    public static void main(String[] args) {
        System.out.println("Test \" \\ ");
        System.out.println(Design.escape("Test \" \\ "));
    }

    public void setRName(String name) {
        this.rName = RControl.getR().eval("make.names(" + name + ")").asRChar().getData()[0];
    }

    public String getRSignature() {
        String rSignature = "p = " + this.p + ", n = " + this.s + ", t = " + this.t;
        return rSignature;
    }

    public String toString() {
        return this.title + " (" + this.signature + ")";
    }

    public String getRDesign() {
        return this.design;
    }

    public String getTextDesign() {
        if (this.result != null) {
            return this.result;
        }
        this.result = RControl.getR().eval("paste(capture.output(print(" + (this.uniqueName == null ? this.design : this.uniqueName) + ")), collapse=\"\\n\")").asRChar().getData()[0];
        return this.result;
    }

    public String getHTMLTable() {
        String result = RControl.getR().eval("Crossover:::getTable(" + (this.uniqueName == null ? this.design : this.uniqueName) + ", type=\"" + Configuration.getInstance().getProperty("outputF", "HTML") + "\"" + ", names=" + (Boolean.parseBoolean(Configuration.getInstance().getProperty("showNames", "true")) ? "TRUE" : "FALSE") + ")").asRChar().getData()[0];
        return result;
    }
}

