% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cucubes.R
\name{ComputeMaxInfoGains}
\alias{ComputeMaxInfoGains}
\title{Max information gains}
\usage{
ComputeMaxInfoGains(acceleration.type = "scalar", dimensions = 1,
  divisions = 1, discretizations = 1, seed = 0, range = 1,
  pseudo.count = 0.001, reduce.method = "max", data, decision)
}
\arguments{
\item{acceleration.type}{acceleration type
('scalar' for none, 'avx'/'avx2' for use of the AVX/AVX2 instruction set respectively, 'cuda' for CUDA)}

\item{dimensions}{number of dimensions}

\item{divisions}{number of divisions}

\item{discretizations}{number of discretizations}

\item{seed}{seed for PRNG used during discretizations}

\item{range}{discretization range (from 0.0 to 1.0)}

\item{pseudo.count}{pseudo count}

\item{reduce.method}{discretization reduce method (either "max" or "mean")}

\item{data}{input data where columns are variables and rows are observations}

\item{decision}{decision variable as a boolean vector of length equal to number of observations}
}
\value{
numeric vector with max information gain for each input variable
}
\description{
Max information gains
}
\examples{
  ComputeMaxInfoGains(data = madelon$data, decision = madelon$decision,
    discretizations = 1, range = 0, divisions = 22, dimensions = 1)
}

