% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wasser_test.R
\name{wasser.test}
\alias{wasser.test}
\title{Statistical Test with Wasserstein Metric}
\usage{
wasser.test(cases, control, test.stat, paranum = 101, bsn = 5000, q = 2,
  seed = 100)
}
\arguments{
\item{cases}{name of case group data (matrix sample * feature)}

\item{control}{names of control group data (matrix sample * feature)}

\item{test.stat}{test statistic}

\item{paranum}{the number of quatile discretization + 1. Default is discretized by 1 \%.}

\item{bsn}{the number of resampling. Default is bsn = 5000.}

\item{q}{power of Wasserstein metric. Default is q = 2.}

\item{seed}{seed for random generator.}
}
\value{
list of p-value and test statistics.
}
\description{
Statistical Test with Wasserstein Metric
}
\examples{
nrep <- 12
cases <- Map(rbeta,rep(30,nrep),rep(1,nrep),rep(5,nrep))
cases <- do.call("rbind",cases)
control <- Map(rbeta,rep(30,nrep),rep(1,nrep),rep(5,nrep))
control <- do.call("rbind",control)
d <- wasserMetric(cases,control)
testRes <- wasser.test(cases = cases,control = control,test.stat = d)
}
\author{
Yusuke Matsui & Teppei Shimamura
}
\references{
Yusuke Matsui, Masahiro Mizuta, Satoru Miyano and Teppei Shimamura.(2015) D3M:Detection of differential distributions of methylation patterns (submitted). BIORXIV/2015/023879.

Antonio Irpino and Rossanna Verde.(2015) Basic Statistics for distributional symbolic variables: a new metric-based approach. Adv.Data.Anal.Classif(9) 143--175
}

