% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskFiles.R
\name{jpegReport}
\alias{jpegReport}
\title{Graphics devices for \code{JPEG} format bitmap files.}
\usage{
jpegReport(
  task,
  type,
  ext = "jpg",
  subdir = NULL,
  dirCreate = TRUE,
  dim = c(500, 500),
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{Should be plotting be done using Windows GDI or cairographics?}

\item{ext}{Filename extension.}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{dim}{device height and width in \code{px}.}

\item{width}{device height in \code{px}.}

\item{height}{device height in \code{px}.}

\item{...}{
  Arguments passed on to \code{\link[grDevices:png]{grDevices::jpeg}}
  \describe{
    \item{\code{filename}}{the path of the output file, up to 511 characters.  The
    page number is substituted if a C integer format is included in the
    character string, as in the default, and tilde-expansion is
    performed (see \code{\link{path.expand}}).   (The result must be less than
    600 characters long.  See \code{\link[grDevices]{postscript}} for further
    details.)
  }
    \item{\code{units}}{The units in which \code{height} and \code{width} are
    given.  Can be \code{px} (pixels, the default), \code{in} (inches),
    \code{cm} or \code{mm}.}
    \item{\code{pointsize}}{the default pointsize of plotted text, interpreted as
    big points (1/72 inch) at \code{res} ppi.}
    \item{\code{bg}}{the initial background colour: can be overridden by setting
    par("bg").}
    \item{\code{quality}}{the \sQuote{quality} of the JPEG image, as a
    percentage.  Smaller values will give more compression but also more
    degradation of the image.}
    \item{\code{res}}{The nominal resolution in ppi which will be recorded in the
    bitmap file, if a positive integer.  Also used for units other than
    the default.  If not specified, taken as 72 ppi to set the size of
    text and line widths.}
    \item{\code{family}}{A length-one character vector specifying the default
    font family.  The default means to use the font numbers on the
    Windows GDI versions and \code{"sans"} on the cairographics
    versions.}
    \item{\code{restoreConsole}}{See the \sQuote{Details} section of
    \code{\link[grDevices]{windows}}.  For \code{type == "windows"} only.}
    \item{\code{antialias}}{Length-one character vector.

    For allowed values and their effect on fonts with \code{type =
      "windows"} see \code{\link[grDevices]{windows}}: for that type if the
    argument is missing the default is taken from
    \code{windows.options()$bitmap.aa.win}.

    For allowed values and their effect (on fonts and lines, but not
    fills) with \code{type = "cairo"} see \code{\link[grDevices]{svg}}.}
    \item{\code{symbolfamily}}{  For cairographics only:
      a length-one character string that specifies the font family to
      be used as the "symbol" font (e.g., for \link[grDevices]{plotmath} output).
      The default value is "default", which means that R will choose
      a default "symbol" font based on the graphics device capabilities.}
  }}
}
\value{
the file name invisibly.
}
\description{
Graphics devices for \code{JPEG} format bitmap files.
}
