% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prediction_breakdown.R
\name{plot.prediction_breakdown_explainer}
\alias{plot.prediction_breakdown_explainer}
\title{Plot Break Down Explanations (Single Prediction)}
\usage{
\method{plot}{prediction_breakdown_explainer}(x, ...,
  add_contributions = TRUE, vcolors = c(`-1` = "#f05a71", `0` =
  "#371ea3", `1` = "#8bdcbe", X = "#371ea3"), digits = 3,
  rounding_function = round)
}
\arguments{
\item{x}{a single prediction exlainer produced with the \code{\link{single_prediction}} function}

\item{...}{other explainers that shall be plotted together}

\item{add_contributions}{shall variable contributions to be added on plot?}

\item{vcolors}{named vector with colors}

\item{digits}{number of decimal places \code{round} or significant digits \code{signif} to be used.
See the \code{rounding_function} argument}

\item{rounding_function}{function that is to used for rounding numbers.
It may be \code{signif()} which keeps a specified number of significant digits.
Or the default \code{round()} to have the same precision for all components}
}
\value{
a ggplot2 object
}
\description{
Function \code{plot.single_prediction_explainer}
plots break down plots for a single prediction.
}
\examples{
 \dontrun{
new_dragon <- data.frame(year_of_birth = 200,
     height = 80,
     weight = 12.5,
     scars = 0,
     number_of_lost_teeth  = 5)

dragon_lm_model4 <- lm(life_length ~ year_of_birth + height +
                                     weight + scars + number_of_lost_teeth,
                       data = dragons)
dragon_lm_explainer4 <- explain(dragon_lm_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_4v")
dragon_lm_predict4 <- prediction_breakdown(dragon_lm_explainer4, observation = new_dragon)
plot(dragon_lm_predict4)

library("randomForest")
dragon_rf_model4 <- randomForest(life_length ~ year_of_birth + height + weight +
                                               scars + number_of_lost_teeth,
                                 data = dragons)
dragon_rf_explainer4 <- explain(dragon_rf_model4, data = dragons, y = dragons$year_of_birth,
                                label = "model_rf")
dragon_rf_predict4 <- prediction_breakdown(dragon_rf_explainer4, observation = new_dragon)
plot(dragon_rf_predict4)

# both models
plot(dragon_rf_predict4, dragon_lm_predict4)

library("gbm")
# create a gbm model
model <- gbm(life_length ~ year_of_birth + height + weight + scars + number_of_lost_teeth,
             data = dragons,
             distribution = "gaussian",
             n.trees = 1000,
             interaction.depth = 4,
             shrinkage = 0.01,
             n.minobsinnode = 10,
             verbose = FALSE)
 # make an explainer for the model
 explainer_gbm <- explain(model, data = dragons, predict_function =
         function(model, x) predict(model, x, n.trees = 1000))
 # create a new observation
 exp_sgn <- prediction_breakdown(explainer_gbm, observation = new_dragon)
 head(exp_sgn)
 plot(exp_sgn)

 exp_sgn <- prediction_breakdown(explainer_gbm, observation = new_dragon, baseline = 0)
 plot(exp_sgn)
 }

}
