% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{combTest}
\alias{combTest}
\title{Test for Combining Categories in Multinomial Logistic Regression Models.}
\usage{
combTest(obj)
}
\arguments{
\item{obj}{An object of class \code{multinom}.}
}
\value{
A matrix of test statistics and p-values.
}
\description{
Tests the null hypothesis that categories can be combined in Multinomial
Logistic Regression Models
}
\examples{

library(nnet)
data(france)
mnl.mod <- multinom(vote ~ age + male + retnat + lrself, data=france)
combTest(mnl.mod)


}
\author{
Dave Armstrong
}
