% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{tidy_boot_ci}
\alias{tidy_boot_ci}
\title{Tidy Bootstrap Confidence Intervals}
\usage{
tidy_boot_ci(
  obj,
  indices = NULL,
  type = c("norm", "basic", "stud", "perc", "bca"),
  conf = 0.95,
  term_names = NULL,
  ...
)
}
\arguments{
\item{obj}{An object of class \code{boot}.}

\item{indices}{The column numbers of \code{obj$t} to be used in the calculation. 
if \code{NULL}, all columns are used.}

\item{type}{The type of confidence interval to be produced.  Unlike \code{boot.ci()}, 
"all" is not an option.}

\item{conf}{The confidence level to be used for the interval.}

\item{term_names}{The names of the parameters to be used as identifiers in the tibble.}

\item{...}{Other arguments to be passed down to \code{boot.ci()}}
}
\value{
A tibble with the term name, estimate, lower and upper confidence bounds.
}
\description{
Returns a tibble with confidence intervals for all parameters from a bootstrapping
object estimated with the \code{boot()} function.
}
