% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_DAP.R
\name{apply_DAP}
\alias{apply_DAP}
\title{Apply DAP for binary classification}
\usage{
apply_DAP(xtrain, ytrain, xtest, ytest = NULL, lambda_seq = NULL,
  n_lambda = 50, maxmin_ratio = 0.1, nfolds = 5, eps = 1e-04,
  maxiter = 10000, myseed = 1001, prior = TRUE)
}
\arguments{
\item{xtrain}{A n x p training dataset; n observations on the rows and p features on the columns.}

\item{ytrain}{A n vector of training group labels, either 1 or 2.}

\item{xtest}{A m x p testing dataset; m observations on the rows and p features on the columns.}

\item{ytest}{An optional m vector of testing group labels, either 1 or 2. If supplied,
the function returns misclassification error rate;
if \code{NULL}, the function returns predicted labels for \code{xtest}. 
Default is \code{NULL}.}

\item{lambda_seq}{An optional sequence of tunning parameters lambda. Default is \code{NULL}, and the function generates its own sequence.}

\item{n_lambda}{Number of lambda values, the default is 50.}

\item{maxmin_ratio}{Smallest value for lambda, as a fraction of maximal value for which all coefficients are zero. The default is 0.1.}

\item{nfolds}{Number of folds for cross-validation, the default is 5.}

\item{eps}{Convergence threshold for the block-coordinate decent
algorithm based on the maximum element-wise change in \eqn{V}. The
default is 1e-4.}

\item{maxiter}{Maximum number of iterations, the default is 10000.}

\item{myseed}{Optional specification of random seed for generating the folds, the default value is 1001.}

\item{prior}{A logical indicating whether to put larger weights to the groups of larger size; the default value is \code{TRUE}.}
}
\value{
A list of
       \item{error}{Misclassification error rate (if \code{ytest} is provided).}
       \item{ypred}{Predicted labels on the test set (if \code{ytest} is \code{NULL}).}
       \item{features}{Number of selected features.}
       \item{feature_id}{Index of selected features.}
}
\description{
Applies Discriminant Analysis via Projections to perform binary classification on the test dataset based on the training data.
}
\details{
If no feature is selected by DAP, the function will return \code{error} of 0.5 and no \code{ypred}, indicating that the classifier is no better than random guessing.
}
\examples{
## This is an example for apply_DAP

## Generate data
n_train = 50
n_test = 50
p = 100
mu1 = rep(0, p)
mu2 = rep(3, p)
Sigma1 = diag(p)
Sigma2 = 0.5* diag(p)

## Build training data and test data
x1 = MASS::mvrnorm(n = n_train, mu = mu1, Sigma = Sigma1)
x2 = MASS::mvrnorm(n = n_train, mu = mu2, Sigma = Sigma2)
xtrain = rbind(x1, x2)
x1_test = MASS::mvrnorm(n = n_test, mu = mu1, Sigma = Sigma1)
x2_test = MASS::mvrnorm(n = n_test, mu = mu2, Sigma = Sigma2)
xtest = rbind(x1_test, x2_test)
ytrain = c(rep(1, n_train), rep(2, n_train))
ytest = c(rep(1, n_test), rep(2, n_test))

## Apply DAP

# Given ytest, the function will return a miclassification error rate.
ClassificationError = apply_DAP(xtrain, ytrain, xtest, ytest)

# Without ytest, the function will return predictions.
Ypredict = apply_DAP(xtrain, ytrain, xtest)
}
