% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{demo_group_diff}
\alias{demo_group_diff}
\title{Demographic Group Differences}
\usage{
demo_group_diff(score_csv_data, group_csv_data, m_cutoff = 0.15, group_name)
}
\arguments{
\item{score_csv_data}{This function requires a csv data file. Its name
(e.g., "data_treat_pre.csv") can be passed as an argument. Make sure to set
the folder with the data file(s) as the working directory.}

\item{group_csv_data}{This function requires a csv data file. Its name
(e.g., "demographic_data.csv") can be passed as an argument. Make sure to set
the folder with the data file(s) as the working directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}

\item{group_name}{This function requires a group name as indicated in the csv
data file (e.g., "gender", "grade")}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{descriptive_statistics}: Descriptive statistics
 \item \code{boxplots}: Boxplots - visual presentation of the descriptive
 statistics
 \item \code{shapiro_wilk_test}: Shapiro-Wilk test results to determine
 normality of residuals
 \item \code{normal_qq_plot}: The normal q-q plot to visually inspect the
 normality of residuals
 \item \code{levene_test}: Test homogeneity of variances
 \item \code{one_way_anova}: Results of the one-way anova with equal
 variances assumed
 \item \code{one_way_anova_pwc}: Pairwise t-test results for the
 one-way ANOVA with equal variances assumed
 \item \code{welch_anova_test}: Results of the one-way ANOVA with unequal
 variance
 \item \code{games_howell_test}: Pairwise t-test results for the
 one-way ANOVA with unequal variances assumed
 \item \code{kruskal_wallis_test}: Results of the Kruskal-Wallis test (non-
 parametric version of the one-way ANOVA)
 \item \code{kruskal_wallis_test_pwc}: Pairwise t-test results for the
 Kruskal-Wallis test
}
}
\description{
This function automatically combines demographic variables to a dataset,
and runs the analysis of variance (ANOVA) with assumptions check to examine
demographic sub-group differences all at once. Please make sure to name data
files accurately and have them saved in the working directory.
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
demo_group_diff(score_csv_data =
        system.file("extdata", "data_treat_pre.csv", package = "DBERlibR"),
        group_csv_data =
        system.file("extdata", "demographic_data.csv", package = "DBERlibR"),
        m_cutoff = 0.15,
        group_name = "grade")

}
