% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{paired_samples}
\alias{paired_samples}
\title{Paired Samples Data Analysis}
\usage{
paired_samples(pre_csv_data, post_csv_data, m_cutoff = 0.15)
}
\arguments{
\item{pre_csv_data}{This function requires a csv file with pre-test data.
Its name (e.g., "data_treat_pre.csv") can be passed as an argument. Make sure
to set the folder with the data file(s) as the working directory.}

\item{post_csv_data}{This function requires a csv file with post-test data.
Its name (e.g., "data_treat_post.csv") can be passed as an argument.
Make sure to set the folder with the data file(s) as the working directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{shapiro_wilk_test}: Shapiro-Wilk test results to determine
 normality
 \item \code{normal_qq_plot}: The normal q-q plot to visually inspect the
 normality
 \item \code{descriptive_statistics}: Descriptive statistics
 \item \code{boxplots}: Boxplots - visual presentation of the descriptive
 statistics
 \item \code{paired_samples_t_test}: Paired samples t-test results
 \item \code{wilcoxon_signed_rank_test}: Wilcoxon signed rank test results
}
}
\description{
This function automatically cleans the datasets (e.g., converting missing
values to "0), merges pre-post datasets, checks assumptions, and then runs
the (parametric) Paired Samples T-test and (nonparametric) Wilcoxon
Signed-Rank test to help you examine the difference between pre-post scores.
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
paired_samples(pre_csv_data =
         system.file("extdata", "data_treat_pre.csv", package = "DBERlibR"),
         post_csv_data =
         system.file("extdata", "data_treat_post.csv", package = "DBERlibR"),
         m_cutoff = 0.15)

}
