% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmclustering.R
\name{select.seeds}
\alias{select.seeds}
\title{Seed Selection Procedure}
\usage{
select.seeds(sequences, log_space = FALSE, K, seed.size = 3,
  init.size = 2, print = FALSE, smoothing = 1e-04)
}
\arguments{
\item{sequences}{An \code{stslist} object (see
\code{\link[TraMineR]{seqdef}}) of sequences with discrete observations.}

\item{log_space}{Logical, parameter provided to
\code{\link[seqHMM]{fit_model}} for whether to use optimization in log
space or not.}

\item{K}{The number of seeds to select, equal to the number of clusters in a
partition.}

\item{seed.size}{Seed size, the number of sequences to be selected for a
seed.}

\item{init.size}{The number of HMM states in an initial HMM.}

\item{print}{Logical, whether to print intermediate steps or not.}

\item{smoothing}{Smoothing parameter for absolute discounting in
\code{\link{smooth.probabilities}}.}
}
\value{
A partition as a list object with HMMs for the selected seeds.
}
\description{
Seed selection procedure of the DBHC algorithm, also invokes size search
algorithm for seed in \link{size.search}. Used in \code{\link{hmm.clust}}.
}
\seealso{
Used in main function for the DBHC algorithm
  \code{\link{hmm.clust}}.
}
