% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitycheck.R
\name{validate_data}
\alias{validate_data}
\title{validate_data: Part of DCEM package.}
\usage{
validate_data(columns, numcols)
}
\arguments{
\item{columns}{(string): A comma separated
list of columns that needs to be removed from the dataset.
Default: ''}

\item{numcols}{(numeric): Number of columns in the dataset.}
}
\value{
boolean: TRUE if the columns exists otherwise FALSE.
}
\description{
Implements sanity check for the input data. This function is for internal use and is called
by the \code{\link{dcem_train}}.
}
\details{
An example would be to check if the column to be removed exist
or not? \code{\link{trim_data}} internally calls this function before removing
the column(s).
}
\examples{
#Generate a dataframe with 2 columns containing random values.

# Check a range of columns.
validate_data("2,3,4", ncol(data.frame(x1=sample(1:100,10),
x2=sample(500:1000, 10), x3=sample(-100:0,10))))

# Check a single column.

validate_data("2", ncol(data.frame(x1=sample(1:100,10),
x2=sample(500:1000, 10))))

}
\references{
Using data to build a better EM: EM* for big data.

Hasan Kurban, Mark Jenne, Mehmet M. Dalkilic
(2016) <https://doi.org/10.1007/s41060-017-0062-1>.
}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic
This work is partially supported by NCI Grant 1R01CA213466-01.
}
