% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedding.R
\name{embedding}
\alias{embedding}
\title{Construction of embedding vectors using the method of delays}
\usage{
embedding(x, m = 3, lag = 1, timelapse = c("FIXED", "VARIABLE"))
}
\arguments{
\item{x}{a numeric vector, time serie, data frame or matrix depending on the method selected in \code{timelapse}.}

\item{m}{a non-negative integer denoting the embedding dimension (Default 3).}

\item{lag}{a non-negative integer denoting the reconstruction delay (Default 1).}

\item{timelapse}{a character denoting if you consider that the observations are sampled at uniform time intervals \code{FIXED} or with a variable time-lapse between each observation \code{VARIABLE} (Default \code{FIXED}).}
}
\value{
A data frame with the uniform or non-uniform embedding vectors by columns from an univariate time serie considering the parameter set selected by the user.
}
\description{
This function generates both the uniform and non-uniform embedding vectors set from an univariate time serie considering the argument set selected by the user.
}
\details{
If \code{FIXED} has been selected \code{x} must be a numeric vector or time serie. Otherwise \code{VARIABLE} has to be specified. In this case \code{x} must be a data frame or matrix with two columns. First, the date with the following format \code{YMD H:M:OS3} considering milliseconds e.g., 20190407 00:00:03.347. If you don't consider milliseconds you must put .000 after the seconds. It should be an object of class \code{Factor}. Second, the univariate time serie as a sequence of numerical values.
}
\examples{
## The first ten values corresponding to the uniform embedding
## vectors set for m=5 and lag=1 are showed by simulating
## time series from the logistic equation.
data<-logistic.ts(u.min=4,u.max=4,B=100,doplot=FALSE)
ts<-data$`Logistic 100`$time.serie
embed<-embedding(ts,m=5,lag=1,timelapse="FIXED")
show(head(embed, 10))
}
\references{
Ruelle, D., Takens, F. 1971 On the nature of turbulence. Communications in Mathematical Physics 20(3):167-192.

Packard, N.H., Crutchfield, J.P., Farmer, J.D., Shaw, R.S. 1980 Geometry from a time serie. Physical Review Letters 45:712-716.

Takens, F. 1981 Detecting strange attractors in turbulence. Springer Berlin Heidelberg.

Sauer, T., Yorke, J.A., Casdagli, M. 1991 Embedology. Journal of Statistical Physics 65(3):579-616.

Huke, J.P., Broomhead, D.S. 2007 Embedding theorems for non-uniformly sampled dynamical systems. Nonlinearity 20(9):205-244.
}
\seealso{
\code{\link{jacobi}}
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
