\name{achisq.boot}

\alias{achisq.boot}
\alias{achisq.pboot}

\title{Bootstrap Replicates of Pearson's Chi-square Statistic}


\description{

Generate bootstrap replicates of the Pearson's Chi-square statistic (function
\emph{achisq.stat}), by means of function \emph{boot} from \emph{boot}
library. Notice that these functions should not  be used separately but as
argument \emph{statistic} when calling function \emph{boot}.


\emph{achisq.boot} is used when performing a non-parametric bootstrap.

\emph{achisq.pboot} is used when performing a parametric bootstrap.
}


\usage{
achisq.boot(data, i, ...)
achisq.pboot(...)
}

\arguments{
\item{data}{A dataframe containing the data, as specified in
\emph{DCluster} manpage.}
\item{i}{Permutation generated by the non-parametric bootstrap procedure.}
\item{...}{Additional arguments passed when performing a bootstrap.}
}

\value{
Both functions return the value of the statistic.
}

\seealso{
DCluster, boot, achisq, achisq.stat
}


\examples{
library(boot)
library(spdep)

data(nc.sids)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))

niter<-100

#Permutation  model
chq.perboot<-boot(sids, statistic=achisq.boot, R=niter)
plot(chq.perboot)#Display results

#Multinomial model
chq.mboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=multinom.sim,  R=niter)
plot(chq.mboot)#Display results

#Poisson model
chq.pboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=poisson.sim,  R=niter)
plot(chq.pboot)#Display results

#Poisson-Gamma model
chq.pgboot<-boot(sids, statistic=achisq.pboot, sim="parametric", ran.gen=negbin.sim, R=niter)
plot(chq.pgboot)#Display results
}

\references{
Potthoff, R. F. and Whittinghill, M.(1966). Testing for Homogeneity: I. The Binomial and Multinomial Distributions. Biometrika 53, 167-182.

Potthoff, R. F. and Whittinghill, M.(1966). Testing for Homogeneity: The Poisson Distribution. Biometrika 53, 183-190.
}

\keyword{htest}
