% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.Erlang}
\alias{plot.Erlang}
\title{Density Plot by Erlang kernel}
\usage{
\method{plot}{Erlang}(x, ...)
}
\arguments{
\item{x}{An object of class "Erlang"}

\item{\dots}{Not presently used in this implementation}
}
\value{
Nothing
}
\description{
Plot Kernel density by using Erlang Kernel.
}
\examples{
y <- rexp(23,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
ans <- Erlang(y,90,h)
plot(ans, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
## To add true density along with estimated
d1<-density(y,bw=h)
lines(d1,type="p",col="red")
legend("topright", c("Real Density", "Density by Erlang Kernel"), col=c("red", "black"), lty=c(1,2))
}
\references{
Salha, R. B.; Ahmed, E. S.; Alhoubi, I. M. 2014. Hazard rate function estimation ksing Erlang Kernel. \emph{Pure Mathematical Sciences} \strong{3} (4), 141–152.
}
\seealso{
For further MSE by using other kernels see \code{\link{plot.BS}}, \code{\link{plot.Gamma}} and \code{\link{plot.LN}}. For estimated values \code{\link{Erlang}} and for calculating MSE by using Erlang Kernel \code{\link{mseEr}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
