% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertCounts.R
\name{tpm.direct}
\alias{tpm.direct}
\title{Convert countsMatrix and geneLength to TPM units}
\usage{
tpm.direct(countsMatrix, geneLength, collapse = FALSE)
}
\arguments{
\item{countsMatrix}{A numeric matrix of N genes x M samples. All columns must be numeric.}

\item{geneLength}{Numeric matrix of gene lengths. Often the ExonLength item of a DGEobj.}

\item{collapse}{Default = FALSE. TRUE or FALSE determines whether to use rowMeans on the geneLength matrix.}
}
\value{
A matrix of TPM values
}
\description{
Takes a countsMatrix and geneLength as input and converts to TPM units using the equation from
\href{https://haroldpimentel.wordpress.com/2014/05/08/what-the-fpkm-a-review-rna-seq-expression-units/}{Harold Pimental}.
}
\details{
The result should be the same as using convertCounts with normalize = 'tpm' and log = FALSE.

geneLength can be a vector (length == nrow(countsMatrix)) or a matrix (same dim as countsMatrix).
The geneLength is used as is, or optionally collapsed to a vector by rowMeans.
}
\examples{
   dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

   counts <- DGEobj::getItem(dgeObj, "counts")
   exonLength <- dgeObj$geneData$ExonLength
   tpm <- tpm.direct(counts, geneLength = exonLength)

}
