% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{setAttribute}
\alias{setAttribute}
\title{Set an attribute}
\usage{
setAttribute(dgeObj, attrib, attribName)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{attrib}{An attribute value to add}

\item{attribName}{A name for the attribute}
}
\value{
A DGEobj
}
\description{
Set an attribute on a DGEobj or on a specific item within a DGEobj.
}
\details{
The function adds or updates the attribute passed to it.  To remove an attribute,
pass NULL as the attribute value.
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    # Assign attribute to a DGEobj
    exObj <- setAttribute(exObj, "RNA-SEQ", "Platform")

    # Set attributes on an item inside a DGEobj
    exObj[["counts"]] <- setAttribute(exObj[["counts"]], FALSE, "normalized")

}
