% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{subject}
\alias{subject}
\title{Estimate subject's full network: runs exhaustive search on very node.}
\usage{
subject(X, id = NULL, nbf = 15, delta = seq(0.5, 1, 0.01), cpp = TRUE,
  priors = priors.spec(), path = getwd(), method = "exhaustive")
}
\arguments{
\item{X}{array with dimensions timeseries x nodes.}

\item{id}{subject ID. If set, results are saved to a txt file.}

\item{nbf}{Log Predictive Likelihood will sum from (and including) this time point.}

\item{delta}{a vector of potential values for the discount factor.}

\item{cpp}{boolean true (default): fast C++ implementation, false: native R code.}

\item{priors}{list with prior hyperparameters.}

\item{path}{a path where results are written.}

\item{method}{ether exhaustive, foward, backward, or both.}
}
\value{
store list with results.
}
\description{
Estimate subject's full network: runs exhaustive search on very node.
}
\examples{
data("utestdata")
# select only 3-nodes to speed-up this example
sub=subject(myts[,1:3]) 
sub=subject(myts[,1:3], method="both")

}
