% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inhosp_antibiotics.R
\docType{data}
\name{inhosp_antibiotics}
\alias{inhosp_antibiotics}
\title{DIVINE's table on antibiotics received during hospitalization}
\format{
A data frame with 5813 rows and 17 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{any_antibiotic:}{A factor with levels \code{No} and \code{Yes}. Did the patient receive treatment with antibiotics during hospital admission?}
\item{amoxicillin:}{A factor with levels \code{No} and \code{Yes}. Treatment with amoxicillin}
\item{amoxicillin_clavulanic_acid:}{A factor with levels \code{No} and \code{Yes}. Treatment with amoxicillin and clavulanic acid}
\item{azithromycin:}{A factor with levels \code{No} and \code{Yes}. Treatment with azithromycin}
\item{ceftriaxone:}{A factor with levels \code{No} and \code{Yes}. Treatment with ceftriaxone}
\item{ciprofloxacin:}{A factor with levels \code{No} and \code{Yes}. Treatment with ciprofloxacin}
\item{cotrimoxazole:}{A factor with levels \code{No} and \code{Yes}. Treatment with cotrimoxazole}
\item{levofloxacin:}{A factor with levels \code{No} and \code{Yes}. Treatment with levofloxacin}
\item{linezolid:}{A factor with levels \code{No} and \code{Yes}. Treatment with linezolid}
\item{meropenem:}{A factor with levels \code{No} and \code{Yes}. Treatment with meropenem}
\item{piperacillin:}{A factor with levels \code{No} and \code{Yes}. Treatment with piperacillin}
\item{piperacillin_tazobactam:}{A factor with levels \code{No} and \code{Yes}. Treatment with piperacillin+tazobactam}
\item{teicoplanin:}{A factor with levels \code{No} and \code{Yes}. Treatment with teicoplanin}
\item{other_antibiotic:}{A factor with levels \code{No} and \code{Yes}. Treatment with another antibiotic}
}
}
\usage{
data(inhosp_antibiotics)
}
\description{
Information on antibiotics received for patients included in the DIVINE cohort. Data was collected during hospitalization.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
