% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback.R
\name{log_set_defaults}
\alias{log_set_defaults}
\title{Set default options for all log-functions}
\usage{
log_set_defaults(
  print_this = NULL,
  type = NULL,
  ui = NULL,
  console = NULL,
  logfile = NULL,
  logjs = NULL,
  prefix = NULL,
  suffix = NULL,
  findme = NULL,
  logfile_dir = NULL,
  headless = NULL,
  reset = FALSE
)
}
\arguments{
\item{print_this}{(Optional, String, default: "")}

\item{type}{(Optional, String, default: "Info")
E.g. "Warning", "Error". Default: "Info"}

\item{ui}{(Optional, Boolean/String, default: FALSE)
If true, the message will also be printed to the user in form of a modal.
Can also be a string.}

\item{console}{(Optional, Boolean/String, default: TRUE)
If true, the message will also be printed to the console as is.
Can also be a string.}

\item{logfile}{(Optional, Boolean, default: TRUE)
If true (default) the print_this string will also be printed
to the console.}

\item{logjs}{(Optional, Boolean, default: FALSE)
If true (default: false) the print_this
string will also be printed to the javascript-console.
This only makes sense, if the gui is active.}

\item{prefix}{Prefix (Optional, String, default: "")
This is useful if print_this is an array/list.
Each entry will then be new row with this prefix.}

\item{suffix}{Suffix (Optional, String, default: "")
Same like prefix but at the end of each line.}

\item{findme}{(Optional, String, default: "")
Recommended with length 10.
String to find the message in the code.
E.g. 10-digit random hex from
\url{https://onlinetools.com/random/generate-random-hexadecimal-numbers}}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{(Optional, Boolean, default: TRUE)
Indicating, if the function is run only in the console (headless = TRUE)
or on a GUI frontend (headless = FALSE).}

\item{reset}{(boolean, default = FALSE) Should all parameters be reset to
their default values?}
}
\value{
No return value, called for side effects (see description).
}
\description{
This function sets the default log options. Parameters not
  supplied to this function will be set with the default value. If you
  want to reset all parameters to the default ones, run
  \code{log_set_defaults(reset = TRUE)}. This can also be combined with
  a new custom default value:
  \code{log_set_defaults(reset = TRUE, prefix = "Prefix")}
  which will reset all parameters to default and afterwards assign "Prefix"
  as new global prefix.
}
\examples{
  DIZtools::log_set_defaults(logfile_dir = tempdir())

}
