% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStock.r
\name{plotStock}
\alias{plotStock}
\title{Plot the Stock object parameters}
\usage{
plotStock(x, nsamp = 3, nsim = 500, nyears = 50, proyears = 28,
  col = "darkgray", breaks = 10, lwd = 2, ask = FALSE, incVB = TRUE,
  ...)
}
\arguments{
\item{x}{An object of class Stock (or of class OM)}

\item{nsamp}{Number of random samples for time-series plots}

\item{nsim}{Number of iterations for histograms}

\item{nyears}{Number of historical years}

\item{proyears}{Number of projection years}

\item{col}{Color of histograms}

\item{breaks}{Number of breaks for histograms}

\item{lwd}{line width}

\item{ask}{Ask before displaying next page?}

\item{incVB}{Show the sampled von Bertalanffy growth curves on second page?}

\item{...}{Optional additional arguments passed to \code{plot}}
}
\description{
A function that plots histograms of samples from the Stock object parameters,
and time-series plots of `nsamp` samples of time-varying parameters. Used to 
visually examine the parameter values and ranges entered into the Stock object.
}
\author{
A. Hordyk
}
