% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{dmcFitDE}
\alias{dmcFitDE}
\title{dmcFitDE: Fit DMC to aggregated data using R-package DEoptim}
\usage{
dmcFitDE(
  resOb,
  nTrl = 1e+05,
  minVals = list(),
  maxVals = list(),
  fixedFit = list(),
  nCAF = 5,
  nDelta = 19,
  pDelta = vector(),
  varSP = TRUE,
  rtMax = 5000,
  control = list()
)
}
\arguments{
\item{resOb}{Observed data (see flankerData and simonTask for data format)}

\item{nTrl}{Number of trials to use within dmcSim.}

\item{minVals}{Minimum values for the to-be estimated parameters. This is a list with values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., minVals = list(amp = 10, tau = 5, drc = 0.1, bnds = 20, resMean = 200,
resSD = 5, aaShape = 1, spShape = 2, sigm = 1)).}

\item{maxVals}{Maximum values for the to-be estimated parameters. This is a list with values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., maxVals = list(amp = 40, tau = 300, drc = 1.0, bnds = 150, resMean = 800,
resSD = 100, aaShape = 3, spShape = 4, sigm = 10))}

\item{fixedFit}{Fix parameter to starting value. This is a list with bool values specified individually for
amp, tau, drc, bnds, resMean, resSD, aaShape, spShape, sigm (e.g., fixedFit = list(amp = F,  tau = F, drc = F, bnds = F, resMean = F,
resSD = F, aaShape = F, spShape = F, sigm = T))}

\item{nCAF}{Number of CAF bins.}

\item{nDelta}{Number of delta bins.}

\item{pDelta}{Alternative to nDelta by directly specifying required percentile values}

\item{varSP}{Variable starting point TRUE/FALSE}

\item{rtMax}{limit on simulated RT (decision + non-decisional component)}

\item{control}{Additional control parameters passes to DEoptim}
}
\value{
dmcfit

The function returns a list with the relevant results from the fitting procedure. The list
is accessed with obj$name with the the following:
\item{obj$means}{Condition means for reaction time and error rate}
\item{obj$caf}{Accuracy per bin for compatible and incompatible trials}
\item{obj$delta}{Mean RT and compatibility effect per bin}
\item{obj$sim}{Individual trial data points (reaction times/error) and activation vectors from simulation}
\item{obj$par}{The fitted model parameters + final RMSE of the fit}
}
\description{
Fit theoretical data generated from dmcSim to observed data by
minimizing the root-mean-square error (RMSE) between a weighted combination
of the CAF and CDF functions using the R-package DEoptim.
}
\examples{
\donttest{
# Example 1: Flanker data from Ulrich et al. (2015)
fit <- dmcFitDE(flankerData)  
plot(fit, flankerData)
summary(fit)

# Example 2: Simon data from Ulrich et al. (2015)
fit <- dmcFitDE(simonData, nTrl = 20000)    
plot(fit, simonData)
summary(fit)
}

}
