% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmclist}
\alias{plot.dmclist}
\title{plot.dmclist: Plot delta plots from multiple dmc simulations.}
\usage{
\method{plot}{dmclist}(
  x,
  ylim = NULL,
  xlim = NULL,
  figType = "delta",
  xlab = "Time [ms]",
  ylab = expression(paste(Delta, "Time [ms]")),
  xylabPos = 2,
  col = c("black", "lightgrey"),
  lineType = "l",
  legend = TRUE,
  legend.parameters = list(),
  ...
)
}
\arguments{
\item{x}{Output from dmcSims}

\item{ylim}{ylimit for delta plot}

\item{xlim}{xlimit for delta plot}

\item{figType}{delta (default), deltaErrors}

\item{xlab}{x-label}

\item{ylab}{y-label}

\item{xylabPos}{x/y label position}

\item{col}{color range start/end color}

\item{lineType}{line type ("l", "b", "o") for delta plot}

\item{legend}{TRUE/FALSE Show legend}

\item{legend.parameters}{list}

\item{...}{pars for plot}
}
\value{
Plot (no return value)
}
\description{
Plot delta function from multiple dmc simulations (i.e., dmcSims).
}
\examples{
\donttest{
# Example 1
params <- list(amp = seq(20, 30, 2))
dmc <- dmcSims(params)
plot(dmc, col = c("red", "green"), legend.parameters = list(x = "topright", ncol=2))

# Example 2
params <- list(amp=c(10, 20), tau = c(20, 40), drc = c(0.2, 0.6), nTrl = 50000)
dmc <- dmcSims(params)
plot(dmc, col=c("green", "blue"), ylim = c(-10, 120), legend.parameters=list(ncol=2))

}

}
