% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcFit.R
\name{calculateCostValueRMSE}
\alias{calculateCostValueRMSE}
\title{calculateCostValueRMSE}
\usage{
calculateCostValueRMSE(resTh, resOb)
}
\arguments{
\item{resTh}{list containing caf values for comp/incomp conditions (nbins * 4 columns) and
delta values for comp/incomp conditions (nbins * 5 columns). See output from dmcSim (.$caf).}

\item{resOb}{list containing caf values for comp/incomp conditions (n * 4 columns) and
delta values for comp/incomp conditions (nbins * 5 columns). See output from dmcSim (.$delta).}
}
\value{
cost value (RMSE)
}
\description{
Calculate cost value (fit) using root-mean-square error (RMSE) from a combination of RT and error rate.
}
\examples{
# Example 1:
resTh <- dmcSim()
resOb <- dmcSim()
cost <- calculateCostValueRMSE(resTh, resOb)

# Example 2:
resTh <- dmcSim()
resOb <- dmcSim(tau = 150)
cost <- calculateCostValueRMSE(resTh, resOb)
}
