% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdr.R
\name{read_mdr}
\alias{read_mdr}
\title{read_mdr helper function}
\usage{
read_mdr(utils_path = NULL, mdr_filename = "mdr.csv")
}
\arguments{
\item{utils_path}{A character string. The path to the utils-folder,
containing the required app utilities like the MDR and the settings folder.}

\item{mdr_filename}{A character string. The filename of your meta data
repository (default: 'mdr.csv').}
}
\value{
A data.table containing the metadata repository which is imported
from the CSV file provided with \code{{utils_path}/MDR/{mdr_filename}}.
}
\description{
Internal function to read the meta data repository (MDR).
}
\examples{
utils_path <- system.file(
  "demo_data/utilities/",
  package = "DQAstats"
)
mdr_filename <- "mdr_example_data.csv"
mdr <- read_mdr(
  utils_path = utils_path,
  mdr_filename = mdr_filename
)

}
