% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_csv.R
\name{test_csv}
\alias{test_csv}
\title{test_csv helper function}
\usage{
test_csv(settings, source_db, mdr, headless = FALSE, logfile_dir)
}
\arguments{
\item{settings}{A list object containing the database settings.}

\item{source_db}{A character string. The name of the source database.
This string must be conform with the corresponding config section
in the config.yml-file.}

\item{mdr}{A data.table object containing the MDR.}

\item{headless}{A boolean (default: FALSE). Indicating, if the function is
run only in the console (headless = TRUE) or on a GUI frontend
(headless = FALSE).}

\item{logfile_dir}{The absolute path to folder where the logfile
will be stored default(\code{tempdir()}).}
}
\value{
A boolean indicating if the CSV files specified in the metadata
repository are found in the specified locations.
}
\description{
Internal function to test and get the database connection
of the source database.
}
\examples{
utils_path <- system.file(
  "demo_data/utilities/",
  package = "DQAstats"
)
mdr_filename <- "mdr_example_data.csv"
mdr <- read_mdr(
  utils_path = utils_path,
  mdr_filename = mdr_filename
)

source_system_name <- "exampleCSV_source"
target_system_name <- "exampleCSV_target"

DIZtools::cleanup_old_logfile(logfile_dir = tempdir())

settings <- DIZutils::get_config_env(
  system_name = source_system_name,
  logfile_dir = tempdir(),
  headless = TRUE
)

test_csv(
  settings = settings,
  source_db = source_system_name,
  mdr = mdr,
  headless = TRUE,
  logfile_dir = tempdir()
)


}
