% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_virusandir_ode.R
\name{simulate_virusandir_ode}
\alias{simulate_virusandir_ode}
\title{Simulation of a viral infection model with an immune response}
\usage{
simulate_virusandir_ode(
  U = 1e+05,
  I = 0,
  V = 10,
  T = 0,
  B = 0,
  A = 0,
  n = 0,
  dU = 0,
  dI = 1,
  dV = 4,
  b = 1e-05,
  p = 1000,
  sF = 0.01,
  kA = 1e-05,
  kT = 1e-05,
  pF = 1,
  dF = 1,
  gF = 1,
  Fmax = 1000,
  hV = 1e-06,
  hF = 1e-05,
  gB = 1,
  gT = 1e-04,
  rT = 0.5,
  rA = 10,
  dA = 0.2,
  tstart = 0,
  tfinal = 30,
  dt = 0.05
)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{T}{: initial number of T cells : numeric}

\item{B}{: initial number of B cells : numeric}

\item{A}{: initial number of antibodies : numeric}

\item{n}{: rate of new uninfected cell replenishment : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{sF}{: strength of innate response at reducing virus production : numeric}

\item{kA}{: rate of virus removal by antibodies : numeric}

\item{kT}{: rate of infected cell killing by T cells : numeric}

\item{pF}{: rate of innate response production in absence of infection : numeric}

\item{dF}{: rate of innate response removal in absence of infection : numeric}

\item{gF}{: rate of innate response growth during infection : numeric}

\item{Fmax}{: maximum level of innate response : numeric}

\item{hV}{: innate growth saturation constant : numeric}

\item{hF}{: B-cell growth saturation constant : numeric}

\item{gB}{: maximum growth rate of B cells : numeric}

\item{gT}{: T-cell induction rate : numeric}

\item{rT}{: T-cell expansion rate : numeric}

\item{rA}{: rate of antibody production by B cells : numeric}

\item{dA}{: rate of antibody decay : numeric}

\item{tstart}{: start time of simulation : numeric}

\item{tfinal}{: final time of simulation : numeric}

\item{dt}{: times for which result is returned : numeric}
}
\value{
A list. The list has only one element, called ts.
ts contains the time-series of the simulation.
The 1st column of ts is time, the other columns are the model variables.
}
\description{
This function runs a simulation of a compartment model
which tracks uninfected and infected cells, virus, innate immune response, T-cells, B-cells and antibodies.
The model is implemented as set of ordinary differential equations using the deSolve package.
}
\details{
A compartmental infection model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_virusandir_ode()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_virusandir_ode(V = 100, tfinal = 50, n = 1e5, dU = 1e-2, kT=1e-7)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l',log='y')
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
