% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ast.R
\docType{class}
\name{Node}
\alias{Node}
\title{Simple AST node}
\description{
Abstract Syntaxic Tree (AST) node that will be created by the DSLite R parser.
}
\seealso{
Other parser items: 
\code{\link{BinaryOpNode}},
\code{\link{FormulaNode}},
\code{\link{FunctionNode}},
\code{\link{GroupNode}},
\code{\link{NumericNode}},
\code{\link{ParameterNode}},
\code{\link{RangeNode}},
\code{\link{StringNode}},
\code{\link{SymbolNode}},
\code{\link{UnaryOpNode}}
}
\concept{parser items}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Token value}

\item{\code{parent}}{Parent Node}

\item{\code{children}}{Children Nodes}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Node-new}{\code{Node$new()}}
\item \href{#method-Node-set_parent}{\code{Node$set_parent()}}
\item \href{#method-Node-add_child}{\code{Node$add_child()}}
\item \href{#method-Node-to_string}{\code{Node$to_string()}}
\item \href{#method-Node-to_string_children}{\code{Node$to_string_children()}}
\item \href{#method-Node-accept}{\code{Node$accept()}}
\item \href{#method-Node-clone}{\code{Node$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-new"></a>}}
\if{latex}{\out{\hypertarget{method-Node-new}{}}}
\subsection{Method \code{new()}}{
Simple node constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$new(name = NA, parent = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Token value}

\item{\code{parent}}{Parent Node}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Node object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-set_parent"></a>}}
\if{latex}{\out{\hypertarget{method-Node-set_parent}{}}}
\subsection{Method \code{set_parent()}}{
Set parent Node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$set_parent(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{Parent Node}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-add_child"></a>}}
\if{latex}{\out{\hypertarget{method-Node-add_child}{}}}
\subsection{Method \code{add_child()}}{
Add a child Node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$add_child(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{Child Node}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Node-to_string}{}}}
\subsection{Method \code{to_string()}}{
The string representation of the Node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$to_string()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-to_string_children"></a>}}
\if{latex}{\out{\hypertarget{method-Node-to_string_children}{}}}
\subsection{Method \code{to_string_children()}}{
Get the string representation of the Node's children
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$to_string_children()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-accept"></a>}}
\if{latex}{\out{\hypertarget{method-Node-accept}{}}}
\subsection{Method \code{accept()}}{
Accept visitor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$accept(visitor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{visitor}}{Node visitor object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Node-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Node-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
