% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class.Constructors.R
\name{make.ddf.analysis.list}
\alias{make.ddf.analysis.list}
\title{Creates a list of DDF.Analysis objects}
\usage{
make.ddf.analysis.list(
  dsmodel = list(~cds(key = "hn", formula = ~1)),
  mrmodel = NULL,
  method = "ds",
  criteria = "AIC",
  analysis.strata = data.frame(),
  truncation = 50,
  binned.data = FALSE,
  cutpoints = numeric(0)
)
}
\arguments{
\item{dsmodel}{list of distance sampling model formula specifying the detection function (see \code{?ddf} for further details)}

\item{mrmodel}{not yet implemented}

\item{method}{character only "ds" normal distance sampling currently implemented}

\item{criteria}{character model selection criteria (AIC, AICc, BIC) - only AIC implemented at present.}

\item{analysis.strata}{Dataframe with two columns ("design.id" and 
"analysis.id"). The former gives the strata names as defined in the
design (i.e. the region object) the second specifies how they should 
be grouped (into less strata) for the analyses}

\item{truncation}{numeric truncation distance for analyses}

\item{binned.data}{logical whether the data should be analsed in bins}

\item{cutpoints}{gives the cutpoints of the binned data}
}
\value{
list of objects of class DDF.Analysis
}
\description{
This method creates a list of DDF.Analysis objects each of which describes 
a model to fit to the distance data. The simulation will fit each of these 
models to the data generated in the simulation and select the model with 
the minimum criteria value.
}
\details{
By default this function creates a half-normal detection
 function model \code{dsmodel = list(~cds(key = "hn",
 formula = ~1))} with a truncation distance of 75.
}
\examples{
# A simple half-normal "ds" model can be created using the default values
ddf.analyses <- make.ddf.analysis.list()

# To incorporate model selection between a 'hn' and 'hr' model:
ddf.analyses <- make.ddf.analysis.list(dsmodel = list(~cds(key = "hn",
 formula = ~1),~cds(key = "hr", formula = ~1)), method = "ds", 
 criteria = "AIC")

}
\seealso{
\code{ddf} in \code{library(mrds)}
}
\author{
Laura Marshall
}
