% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_4RMSE.R
\name{compute.rmse}
\alias{compute.rmse}
\title{Root Mean Square Error (RMSE)}
\usage{
compute.rmse(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Estimates the Root Mean Square Error of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of RMSE of two vectors corresponding to univariate signals.
A lower RMSE (\eqn{RMSE \in [0, \inf]}) value indicates a better performance method for the imputation task.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.rmse(Y,X)
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
