% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.min.numerics.R
\name{dt.min.numerics}
\alias{dt.min.numerics}
\title{dt.min.numerics}
\usage{
dt.min.numerics(
  dt.name,
  the.variables = ".",
  the.filter = NULL,
  grouping.variables = NULL,
  sortby.group = TRUE,
  table.format = "wide",
  add.function.name = FALSE,
  return.as = "result",
  envir = parent.frame(),
  na.rm = TRUE,
  non.numeric.value = "missing",
  ...
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object.}

\item{the.variables}{a character vector specifying the variables that we want to apply a function to.  Only values that exist in names(dat) will be used; other values in the.variables will be excluded from the calculation.  When the.variables includes ".", then all values in names(dat) will be selected.  Values of the.variables that also exist in grouping.variables will be excluded from the.variables (but grouped by these values).}

\item{the.filter}{a character value, logical value, or expression stating the logical operations to be performed in filtering the data prior to calculating the.function.}

\item{grouping.variables}{a character vector specifying variables to group by in performing the computation.  Only values that exist in names(dat) will be used.}

\item{sortby.group}{a logical value to specify if the sorting functionality needs to be applied or not}

\item{table.format}{a character vector specifying if table should be in a wide format or a tall format}

\item{add.function.name}{a logical value specifying whether the name of the function applied should be appended to the column names in the resulting table.}

\item{return.as}{describes whether return should be result, code or mixture of both}

\item{envir}{the environment in which the code would be evaluated; parent.frame() by default.}

\item{na.rm}{a logical value specifying whether missing values should be removed from the calculations specified by the.functions.}

\item{non.numeric.value}{if "missing", returns NA for variables that are not numeric, integer, logical, or complex.  Otherwise returns first entry of the vector.}

\item{...}{additional arguments to be passed}
}
\value{
The function's output depends on the 'return.as' parameter:
- If 'return.as' is "result", it generates a modified version of the input data frame or data table, detailing the minimum values for each specified numeric variable, adjusted for any applied filters and groupings. The data is structured according to the specified 'table.format' (wide or tall) and reflects sorting by group if 'sortby.group' is enabled.
- If 'return.as' is "code", the function returns the R code or expressions that would compute these minimum values, giving the user the ability to inspect or execute the code separately.
- For other values of 'return.as', the function may produce both the calculated minimum values and the R code, depending on the function’s specifics.

This function is designed to compute and aggregate minimum values, accounting for the handling of missing data as dictated by 'na.rm' and addressing non-numeric values as per 'non.numeric.value'. It provides insightful analysis into the lower bounds of the dataset’s quantitative variables, particularly after implementing specified subgroupings and filters.
}
\description{
wrapper function that computes the minimal value for each selected quantitative variable in each group after applying a filter.
}
