% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_relative_values.R
\name{get_relative_values}
\alias{get_relative_values}
\title{Find output values at time points relative to the peak (or minimum)}
\usage{
get_relative_values(data, max_min_values_list, t_s, t_ss, Dt_max = TRUE)
}
\arguments{
\item{data}{A list of data.frames (one data.frame for each policy
alternative).}

\item{max_min_values_list}{A list generated by \code{\link[=get_max_min_values]{get_max_min_values()}}.}

\item{t_s}{The total time window to examine before and after the
peak (or minimum) value.}

\item{t_ss}{The interval size for sampling time points within the specified
time window \code{t_s}. For example, if \code{t_s = 20} and \code{t_ss = 10} the function will extract values at
peak_time-20, peak_time-10, peak_time, peak_time+10, peak_time+20.}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}
}
\value{
A list of nested lists with the following elements:
(i) a data.frame of values recorded at specific time steps relative to the
peak time (e.g., peak-10, peak, peak+10) for each model run, and (ii) a
vector of the names of each time step ex. minus_30,minus_20,...,plus_20, plus_30.
}
\description{
For each policy alternative, this function finds the the model
output values for each simulation run at the specified time points relative
to the peak (or minimum) value.
}
\section{data format}{

Each data.frame in \code{data} contains the results from multiple model
runs using different parameter sets (e.g., from probabilistic sensitivity,
uncertainty, or Bayesian inference analysis). The first column contains
the model time and subsequent columns contain the predicted output for
each simulation run at the respective time.
The model time in the first column must contain numeric values indicating
a simulation time (ex. 1, 2, 3,...) or dates (ex. "2021-01-01", "2021-01-02")
which must be in \code{R} Date format (i.e., class="Date"). To ensure a consistent
basis for comparison, the model time in the first column should be the same for
each policy alternative (data.frame).
}

\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
D <- 750
t_s <- 20
t_ss <- 10

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

peak_temporal_list <- get_relative_values(
  psa_data,
  peak_values_list,
  t_s = t_s,
  t_ss = t_ss
)
}
