\name{plot.roc.Daim}
\alias{plot.Daim.vector}
\alias{plot.Daim.list}
\title{Plotting method for roc.Daim Objects}
\description{
  Plot a \code{roc.Daim} object generated by the \code{\link{roc}} function.
}
\usage{
\method{plot}{Daim.vector}(x, color="blue", type="l", bty="n", 
		xlab="False positive rate", ylab="True positive rate", 
		main="ROC curve", \dots)
\method{plot}{Daim.list}(x, color=rgb(1,0,0,alpha=0.5), 
		xlab="False positive rate", ylab="True positive rate", 
		main="ROC curves", legend=TRUE, \dots)
}
\arguments{
  \item{x}{an object of class \code{roc.Daim}.}
  \item{color}{the color used to draw the ROC curve.}
  \item{type}{what type of plot should be drawn: see 
	  argument 'type' by the function \code{\link{plot}}.}
  \item{bty}{the type of box to be drawn around the legend: see \code{\link{legend}}.}
  \item{xlab}{a title for the x axis: see \code{\link{title}}.}
  \item{ylab}{a title for the y axis: see \code{\link{title}}.}
  \item{main}{a main title for the plot, see also \code{\link{title}}.}
  \item{legend}{Should a legend be added?}
  \item{\dots}{graphical parameters can be given as arguments to 'plot'.}
}

\seealso{
  \code{\link{Daim}}, \code{\link{roc.area.Daim}}
}
\examples{
  library(Daim)
  data(Daim.data3)

  M <- roc(Daim.data3[,2], Daim.data3[,1], "pos")
  plot(M)

  M <- roc(Daim.data3[,-1], Daim.data3[,1], "pos")
  plot(M,color=1:4)

}
\keyword{hplot} \keyword{classif}
