% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.r
\name{plot_density}
\alias{plot_density}
\alias{DensityContinuous}
\title{Visualize density estimates for continuous features}
\usage{
plot_density(data, title = NULL, ...)
}
\arguments{
\item{data}{input data to be plotted, in either \link{data.frame} or \link{data.table} format.}

\item{title}{plot title}

\item{\dots}{other arguments to be passed to \link{geom_density}.}
}
\description{
This function visualizes density estimates for each continuous feature.
}
\examples{
# plot using iris data
plot_density(iris)

# plot using random data
set.seed(1)
data <- cbind(sapply(1:9, function(x) {
          runif(500, min = sample(100, 1), max = sample(1000, 1))
        }))
plot_density(data)
}
\seealso{
\link{geom_density} \link{plot_histogram}
}
\keyword{plot_density}
